/*
 * Decompiled with CFR 0.152.
 */
package emulator.assembler;

import emulator.assembler.Instruction;
import emulator.assembler.SymbolTable;
import emulator.hardware.HwWord;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class InstructionList {
    private SymbolTable symbols;
    private SortedMap<Integer, Instruction> instructions;

    public InstructionList(SymbolTable symbols) {
        this.symbols = symbols;
        this.instructions = new TreeMap<Integer, Instruction>();
    }

    public void addInstruction(int address, Instruction instruction) {
        this.instructions.put(address, instruction);
    }

    public String toString() {
        String listing = "";
        for (Map.Entry<Integer, Instruction> entry : this.instructions.entrySet()) {
            listing = String.valueOf(listing) + new HwWord((long)entry.getKey().intValue()).toString() + "  ";
            String raw_bytes = String.valueOf(entry.getValue().getBytes()) + "            ";
            listing = String.valueOf(listing) + raw_bytes.substring(0, 12);
            String label = this.symbols.getJumpLabel(entry.getKey());
            if (label != null) {
                if (label.length() > 10) {
                    label = label.substring(0, 10);
                }
                label = String.valueOf(label) + ":";
            } else {
                label = "";
            }
            label = String.valueOf(label) + "                          ";
            listing = String.valueOf(listing) + label.substring(0, 12);
            String opcode = String.valueOf(entry.getValue().getOpcode()) + "      ";
            listing = String.valueOf(listing) + opcode.substring(0, 5);
            String operand = String.valueOf(entry.getValue().getOperand()) + "               ";
            listing = String.valueOf(listing) + operand.substring(0, 12);
            String remark = this.symbols.getRemark(entry.getKey());
            if (remark != null) {
                listing = String.valueOf(listing) + " ; " + remark;
            }
            listing = String.valueOf(listing) + "\n";
        }
        return listing;
    }

    public int getByteCount() {
        int byte_count = 0;
        for (Map.Entry<Integer, Instruction> entry : this.instructions.entrySet()) {
            byte_count += entry.getValue().getByteCount();
        }
        return byte_count;
    }

    public int getCount() {
        return this.instructions.size();
    }

    public int getAddress(int index) {
        return (Integer)this.instructions.keySet().toArray()[index];
    }

    public Instruction getInstruction(int index) {
        return (Instruction)this.instructions.values().toArray()[index];
    }
}

